// CtrlCard.cpp: implementation of the CCtrlCard class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "DEMO.h"
#include "CtrlCard.h"
#include "adt8940a1.h"


#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CCtrlCard::CCtrlCard()
{

}
/*******************initial motion-card************************

  this function is boot of using motion-card
  
    Return<=0 fail to initial motion-card
	Return>0  Succeed in initial motion-card
	
*****************************************************/
int CCtrlCard::Init_Board()
{

	Result = adt8940a1_initial() ;        //intiial motion-card    
	
	if (Result <= 0) return Result;
 
    for (int i = 1; i<=MAXAXIS; i++)
	{  	 
       //set limit modepositive limit and negative limit is effective,low level is effective
       set_limit_mode (0, i, 0, 0, 0);   
       
       set_command_pos (0, i, 0);        //set logic pos as 0
       
       set_actual_pos (0, i, 0);         //set real pos as 0
       
       set_startv (0, i, 1000);          //set start-speed
       
       set_speed (0, i, 1000);           //set motion-speed

	   set_acc(0, i, 625);               //set acceleration
                         
    }

    return 1;

}


/**********************set speed***********************

  according as para,judge whether is constant-speed
  	
    set start-speed ,motion-speed and acceleration
		  
	 paraaxis   -axis number
			
		   startv -start-speed
			  
		   speed  -motion-speed
				
		   add    -acceleration
				  					
		Return=0 correctReturn=1 wrong
					  
*********************************************************/
int CCtrlCard::Setup_Speed(int axis, long startv, long speed, long add )
{	
	if (startv - speed >= 0) //constant-speed motion
	{    
		Result = set_startv(0, axis, startv);
		
		set_speed (0, axis, startv);

	}
	else                    //Trapezoidal acceleration/ deceleration
	{		
		Result = set_startv(0, axis, startv);
		
		set_speed (0, axis, speed);
		
		set_acc (0, axis, add/125);  
		
	}
	
	return Result;

}
/*********************single-axis motion**********************

  drive one axis motion
  
    para axis-axis numbervalue-pulse of motion
    
	  Return=0 correctReturn=1 wrong
	  
*******************************************************/
int CCtrlCard::Axis_Pmove(int axis, long value)
{
	Result = pmove(0, axis, value);
	
	return Result;

}

/*******************2-axis interpolation********************

  any 2-axis linear interpolation
  
    paraaxis1,axis2-axis numbervalue1,value2-pulse of interpolation
    
	  Return=0 correctReturn=1 wrong
	  
*******************************************************/
int CCtrlCard::Interp_Move2(int axis1, int axis2, long value1, long value2)
{
	Result = inp_move2(0, axis1, axis2, value1, value2);

	return Result;

}
/*******************3-axis interpolation********************
  any 3-axis linear interpolation
  
    paraaxis1,axis2,axis3-axis numbervalue1,value2,value3-pulse of interpolation
    
	  Return=0 correctReturn=1 wrong
	  
*******************************************************/
int CCtrlCard::Interp_Move3(int axis1, int axis2, int axis3, long value1, long value2, long value3)
{
	Result = inp_move3(0, axis1, axis2, axis3, value1, value2, value3);

	return Result;

}

/*******************4-axis interpolation****************************
  4-axis interpolation motion
	para
	     value1,value2,value3,value4-pulse of interpolation
	
	Return=0 correctReturn=1 wrong
	  
***********************************************************/
int CCtrlCard::Interp_Move4(long value1, long value2, long value3, long value4)
{
	Result = inp_move4(0, value1, value2, value3, value4);

	return Result;
}

/*****************stop motion******************************
  stop motion in the way of sudden or decelerate
	para
	     axis-axis number
		 mode-stop mode(0sudden stop, 1decelerate stop)   
	Return=0 correctReturn=1 wrong
************************************************************/
int CCtrlCard::StopRun(int axis, int mode)
{
	if (mode == 0)        //sudden stop
    
        Result = sudden_stop(0, axis);
        
    else                 //decelerate stop
    
        Result = dec_stop(0, axis);
        
    return Result;

}
/*****************get status of motion**************************
  get status of single-axis motion or interpolation 
  para
       axis   -axis number
	   value  -Indicator of motion status(0Drive completed,Non-0: Drive in process)	
	   mode(0-single-axis motion1interpolation)	  
  Return=0 correctReturn=1 wrong		
************************************************************/
int CCtrlCard::Get_Status(int axis, int &value, int mode)
{
	if (mode==0)          //status of single-axis motion

		Result=get_status(0,axis,&value);

	else                  //status of interpolation
		Result=get_inp_status(0,&value);

	return Result;

}

/*****************get information of motion*****************************
  get logic-pos,real-pos and motion-speed
 
    paraaxis    -axis number
	      LogPos  -logic pos
		  ActPos  -real pos
		  Speed   -motion speed  
	  Return=0 correctReturn=1 wrong	  
************************************************************/
int CCtrlCard::Get_CurrentInf(int axis, long &LogPos, long &ActPos, long &Speed )
{
	Result = get_command_pos(0, axis, &LogPos);

	get_actual_pos(0, axis, &ActPos);

	get_speed(0, axis, &Speed);	

	return Result;

}

/***********************read input*******************************

  read status of input
  
	para
	     number-input port(0 ~ 39)
	
	Return0  low level1  high level-1  error
	  
****************************************************************/
int CCtrlCard::Read_Input(int number)
{
	Result = read_bit(0, number);
    
	return Result;
}

/*********************output******************************
  set status 0f output
    para 
	     number-output port(0 ~ 15),value 0-low level1high level
	Return=0 correctReturn=1 wrong
****************************************************************/

int CCtrlCard::Write_Output(int number, int value)
{
	Result = write_bit(0, number, value);

	return Result;

}
/*******************set position counter*******************************
  set logic-pos or  real-pos  
	para
	    axis  -axis number,
		pos   -the set value 
    	mode  0set logic pos,non 0set real pos	
	Return=0 correctReturn=1 wrong
****************************************************************/
	 
int CCtrlCard::Setup_Pos(int axis, long pos, int mode)
{
	if(mode==0)
	{
		Result = set_command_pos(0, axis, pos);
	}
	else
	{
		Result = set_actual_pos(0, axis, pos);
	}

	return Result;

}

/********************get version************************

  get library version and hardware version
  
	para
	     LibVer       library version
		 HardwareVer  - hardware version
	
*********************************************************/
void CCtrlCard::Get_Version(float &LibVer, float &HardwareVer)
{
	int  Ver;
	Ver = get_lib_version(0);	
	LibVer = float(Ver);

	HardwareVer = get_hardware_ver(0);
}

/********************set pulse mode**********************
  set the mode of pulse output
	para
	      axis   -axis number
		  value  -pulse 
		  mode   0pulse+pulse 1pulse + direction	
    Return=0 correctReturn=1 wrong	  
Default mode: Pulse + direction, with positive logic pulse 
		and positive logic direction input signal		  
*********************************************************/
int CCtrlCard::Setup_PulseMode(int axis, int value)
{
	Result = set_pulse_mode(0, axis, value, 0, 0);

	return Result;

}
/********************set nLMT mode**********************

  set the mode of nLMT signal input along positive/ negative direction 
	para 
	      axisaxis number
  	      value1   0 - positive limit effective		1: positive limit ineffective
		  value2   0: negative limit effective      1: negative limit ineffective
		  logic    0: low level effective	    	1: high level ineffective
		  Default mode: Apply positive and negative limits with low level
   Return	0Correct					1 Wrong
*********************************************************/
int CCtrlCard::Setup_LimitMode(int axis, int value1, int value2, int logic)
{
	Result = set_limit_mode(0, axis, value1, value2, logic);

	return Result;

}
/********************set stop0 mode**********************

  Set mode of stop0 input signal
  
	para axisaxis number
	       value   0ineffective  1effective
           logic   0low level effective  1high level effective
		           Defaule : ineffective
		  
Return	0Correct					1 Wrong
*********************************************************/
int CCtrlCard::Setup_Stop0Mode(int axis, int value, int logic)
{
	Result = set_stop0_mode(0, axis, value ,logic);

	return Result;

}
/********************set stop1 mode**********************

  Set mode of stop1 input signal
  
	para axisaxis number
	       value   0ineffective  1effective
	       logic   0low level effective  1high level effective
		           Defaule : ineffective
		  
   Return	0Correct					1 Wrong
*********************************************************/
int CCtrlCard::Setup_Stop1Mode(int axis, int value, int logic)
{
	Result = set_stop1_mode(0, axis, value, logic);

	return Result;

}

/********************set hardware-stop mode **********************

  set mode whether Hardware stop is effective,if hareware-version is 1 ,motion-card havn't this function
  
	para value   0ineffective  1effective
		  logic   0low level effective  1high level effective
		  Defaule : ineffective
		  
	Return	0Correct					1 Wrong			
Hardware stop signals are assigned to use the 34 pin at the P3 terminal panel (IN31)
*********************************************************/
int CCtrlCard::Setup_HardStop(int value, int logic)
{
	Result = set_suddenstop_mode(0, value, logic);

	return Result;

}
/********************set delay**********************

  set the time of delay,if hareware-version is 1 ,motion-card havn't this function
	para time - time of delay(unit is us)	
	Return	0Correct					1 Wrong	  
*********************************************************/
int CCtrlCard::Setup_Delay(long time)
{
	Result = set_delay_time(0, time*8);

	return Result;

}
/********************get delay status **********************

  get the status of delay ,if hareware-version is 1 ,motion-card havn't this function
  
	Return   0: delay stop          1: delay in process
	
*********************************************************/
int CCtrlCard::Get_DelayStatus()
{
	Result = get_delay_status(0);

	return Result;
}

/************ Symmetrical relative movement of single-axis ***************
function: Refer to the current position and perform quantitative movement in the symmetrical
acceleration/deceleration
para:
	 axis---axis number
	 pulse-- Pulse
	 lspd--- Low speed
	 hspd--- High speed
	 tacc--- Time of acceleration (Unit: sec)
return value 0correct 1wrong
*******************************************************************/
int CCtrlCard::Sym_RelativeMove(int axis, long pulse, long lspd ,long hspd, double tacc)
{
	Result= symmetry_relative_move(0,axis, pulse, lspd ,hspd, tacc);

    return Result;
}

/************** Symmetrical absolute movement of single-axis ***********
function: Refer to the position of zero point and perform quantitative movement in the symmetrical
acceleration/deceleration
para:
     axis ---axis number
	 pulse -- Pulse
	 lspd --- Low speed
	 hspd --- High speed
	 tacc--- Time of acceleration (Unit: sec)
return value 0: correct 1: wrong
*******************************************************************/

int CCtrlCard::Sym_AbsoluteMove(int axis, long pulse, long lspd ,long hspd, double tacc)
{
	Result= symmetry_absolute_move(0,axis, pulse, lspd ,hspd, tacc);

    return Result;
}

/***** Relative movement of two-axis symmetrical linear interpolation ********
function: Refer to current position and perform linear interpolation in symmetrical
acceleration/deceleration
para:
	 axis1---axis number1
	 axis2---axis number2
	 pulse1-- pulse 1
	 pulse2-- pulse 2
	 lspd --- Low speed
	 hspd --- High speed
	 tacc--- Time of acceleration (Unit: sec)
return value 0correct 1wrong
******************************************************************/
int CCtrlCard::Sym_RelativeLine2(int axis1, int axis2, long pulse1, long pulse2, long lspd ,long hspd, double tacc)
{
	Result= symmetry_relative_line2(0, axis1, axis2, pulse1,pulse2, lspd ,hspd,tacc);

    return Result;
}

/****** Two axes symmetric linear interpolation absolute moving ********
function: Refer to the position of zero point and perform linear interpolation in symmetrical
acceleration/deceleration
para:
	 axis1---axis number1
	 axis2---axis number2
	 pulse1pulse of axis 1
	 pulse2-- pulse of axis 2
	 lspd --- Low speed
	 hspd --- High speed
	 tacc--- Time of acceleration (Unit: sec)
return value 0correct 1wrong
******************************************************************/
int CCtrlCard::Sym_AbsoluteLine2(int axis1, int axis2, long pulse1, long pulse2, long lspd ,long hspd, double tacc)
{
	Result= symmetry_absolute_line2(0, axis1, axis2, pulse1, pulse2, lspd ,hspd, tacc);

    return Result;
}

/***** Three axes symmetric linear interpolation relative moving ******
function: Refer to current position and perform linear interpolation in symmetric
acceleration/deceleration
para:
	 axis1---axis number1
	 axis2---axis number2
	 axis3---axis number3
	 pulse1-- pulse of axis 1
	 pulse2-- pulse of axis 2
	 pulse3-- pulse of axis 3
	 lspd --- Low speed
	 hspd --- High speed
	 tacc--- Time of acceleration (Unit: sec)
return value 0correct 1wrong
******************************************************************/
int CCtrlCard::Sym_RelativeLine3(int axis1, int axis2, int axis3, long pulse1, long pulse2, long pulse3, long lspd ,long hspd, double tacc)
{
	Result= symmetry_relative_line3(0,axis1, axis2, axis3, pulse1, pulse2, pulse3, lspd ,hspd, tacc);

    return Result;
}

/******Three axes symmetric linear interpolation absolute moving **********
function: Refer to the position of zero point and perform linear interpolation in symmetric
acceleration/deceleration.
para:
	 axis1---axis number1
	 axis2---axis number2
	 axis3---axis number3
	 pulse1-- pulse of axis 1
	 pulse2-- pulse of axis 2
	 pulse3-- pulse of axis 3
	 lspd --- Low speed
	 hspd --- High speed
	 tacc--- Time of acceleration (Unit: sec)
return value 0correct 1wrong
******************************************************************/
int CCtrlCard::Sym_AbsoluteLine3(int axis1, int axis2, int axis3, long pulse1, long pulse2, long pulse3, long lspd ,long hspd, double tacc)
{
	Result= symmetry_absolute_line3(0, axis1, axis2,axis3,pulse1, pulse2,  pulse3,  lspd , hspd,  tacc);

    return Result;
}

/***** Four axes symmetric linear interpolation relative moving ******
function: Refer to current position and perform linear interpolation in symmetric
acceleration/deceleration
para:
	 pulse1-- pulse of axis 1
	 pulse2-- pulse of axis 2
	 pulse3-- pulse of axis 3
	 pulse4-- pulse of axis 4
	 lspd --- Low speed
	 hspd --- High speed
	 tacc--- Time of acceleration (Unit: sec)
return value 0correct 1wrong
******************************************************************/
int CCtrlCard:: Sym_RelativeLine4(long pulse1, long pulse2, long pulse3,  long pulse4,long lspd ,long hspd, double tacc)
{
	Result=symmetry_relative_line4( 0, pulse1,  pulse2, pulse3, pulse4,lspd ,hspd, tacc);
    
	return Result; 
}

/******Four axes symmetric linear interpolation absolute moving **********
function: Refer to the position of zero point and perform linear interpolation in symmetric
acceleration/deceleration.
para:
	 pulse1-- pulse of axis 1
	 pulse2-- pulse of axis 2
	 pulse3-- pulse of axis 3
	 pulse4-- pulse of axis 4
	 lspd --- Low speed
	 hspd --- High speed
	 tacc--- Time of acceleration (Unit: sec)
return value 0correct 1wrong
******************************************************************/
int CCtrlCard::Sym_AbsoluteLine4(long pulse1, long pulse2, long pulse3, long pulse4,long lspd ,long hspd, double tacc)
{
	Result= symmetry_absolute_line4(0,  pulse1,  pulse2,  pulse3,  pulse4, lspd , hspd,  tacc);
	
	return Result; 
}

/********************get Output **********************
    cardno	    card number
    number		Output
	Return      Output status          -1: parameter wrong	
*********************************************************/

int CCtrlCard::Get_OutNum(int number)
{
	Result=get_out(0,number);

	return Result; 
}

/************ Quantitative drive function of external signal *******
function: Quantitative drive function of external signal
para:
     cardno    card number
     axis      axis number
     pulse     pulse
Return 0Correct 1Wrong
******************************************************************/
int CCtrlCard::Manu_Pmove(int axis, long pulse)
{   
	Result= manual_pmove(0, axis, pulse);

	return Result;
}

/************* Continuous drive function of external signal ********
function: Continuous drive function of external signal
para:
     cardno   card number
     axis     axis number
Return 0Correct 1Wrong
******************************************************************/
int CCtrlCard::Manu_Continue(int axis)
{   
	Result= manual_continue(0, axis);

	return Result;
}

/*********** Shut down the enabling of external signal drive ********
function: Shut down the enabling of external signal drive
para:
     cardno    card number
     axis      axis number
Return 0Correct 1Wrong
******************************************************************/
int CCtrlCard::Manu_Disable(int axis)
{   
	Result= manual_disable(0, axis);

	return Result;
}
/*********************** set lockmode ***************************
function:lock the logical position and real position for all axis
para:
     axisreference axis
	 mode--set lock mode    |0:inefficacy
	                        |1:efficiency
     regiregister mode    |0:logical position
                            |1:real position
     logicallevel signal  |0: from high to low
                            |1:from low to high
retutrn 0correct 1wrong
Note: Use IN signal of specific axis as the trigger signal
****************************************************************/

int CCtrlCard::Setup_LockPosition(int axis,int mode,int regi,int logical)
{
	Result = set_lock_position(0, axis, mode, regi , logical);
	
	return Result;
} 

/******************** get synchronous action state ***********************
function:get synchronous action state
para:
     axis      axis number
     status  0|haven't run synchronous
               1|run synchronous
retutrn 0correct 1wrong
Note: This function could tell whether the position lock has been executed
****************************************************************************/

int CCtrlCard::Get_LockStatus(int axis,int &v)
{
      Result=get_lock_status(0,  axis, &v);

	  return Result;
}

/**********************get lock position************************
Function: Get the locked position
para:
     axis      axis number
     pos lock position
Return 0Correct 1Wrong
******************************************************************/
int CCtrlCard::Get_LockPosition(int axis,long &pos)
{
	Result= get_lock_position(0, axis, &pos);
	
    return Result;
}
/**********************clean lock position************************
Function: Clean the locked position
para:
     axis      axis number
Return 0Correct 1Wrong
******************************************************************/
int CCtrlCard::Clr_LockPosition(int axis)
{
	Result= clr_lock_status(0, axis);
	
    return Result;
}